# Q&A Readiness

**Why "ask in plain English" usually fails — and what to fix first.**

---

## The Problem You’re Solving

Someone opens your report, types **"What was revenue last month?"** in the Q&A box, and gets a generic answer, the wrong visual, or "I couldn’t find that." The data is there; the model just doesn’t speak the same language as the person asking. This guide fixes that with **names, synonyms, and hierarchies** — no new tools required.

---

## What Actually Breaks Q&A

1. **Names only a developer would use** — e.g. `GrossMarginPct`, `Rev_YTD`. Q&A matches the words people type; if they say "margin" or "revenue this year," it won’t map unless you help.
2. **No synonyms** — One term in the model (e.g. "Revenue") but users say "sales," "top line," "income." One synonym list fixes that.
3. **Missing or flat hierarchies** — Questions like "by region then by country" need a proper hierarchy; otherwise Q&A can’t drill.

Fix those three and most "Q&A doesn’t work" complaints go away.

---

## 1. Clear, Business-Friendly Names

- **Tables:** Name them what the business calls them (e.g. "Sales" not "fact_sales_agg").
- **Columns and measures:** Prefer "Revenue," "Units Sold," "Average Selling Price" over abbreviations and code names.
- **Hide or rename** technical columns (IDs, keys) so they don’t clutter Q&A; keep them for relationships only.

**Quick win:** Pick one table (e.g. Sales or Orders), rename one measure and one column to how leadership says it in a meeting. Test that phrase in Q&A.

---

## 2. Synonyms (Where the Magic Is)

- Add synonyms for **measures** and **key dimensions** so different ways of asking map to the same thing.
- Examples:
  - **Revenue** → "sales," "top line," "income"
  - **Gross margin** → "margin," "profit %," "GM"
  - **Units sold** → "quantity," "volume," "units"
- Include **plurals** and **abbreviations** your team uses.

**In Power BI:** Model view → select table/column/measure → **Synonyms** in the Properties pane. Add comma-separated alternatives.

**In Fabric:** Same idea in the semantic model — synonyms on tables, columns, and measures.

---

## 3. Hierarchies for "By Region, Then by Country"

- Build **drill-down hierarchies** (e.g. Region → Country → City, or Category → Subcategory → Product).
- Q&A uses these to answer "by X" and "break down by Y" correctly.

---

## Checklist (Run It on One Report First)

- [ ] At least one table has business-friendly names (not only technical)
- [ ] 3–5 key measures have synonyms (revenue, margin, count, etc.)
- [ ] 2–3 key columns have synonyms (customer, product, date, etc.)
- [ ] One hierarchy exists where "by X" matters
- [ ] You tested 3–5 real questions in the Q&A visual and got the right (or close) answer

---

## Next Step

Go to **Linguistic Schemas and Synonyms** for exact steps in Power BI and Fabric, plus before/after examples.
