# Linguistic Schemas and Synonyms

**Where to click and what to type so Q&A actually understands your users.**

---

## Why This Matters

Your model has "Revenue" and "Gross Margin %." Users type "sales" and "profit margin." Without synonyms, Q&A won’t match. Adding them is a few minutes per object and dramatically improves answers.

---

## In Power BI Desktop (or Service)

1. Open your report and go to **Model view** (left-hand icon).
2. Select a **table**, **column**, or **measure** in the diagram.
3. In the **Properties** pane, find **Synonyms** (or "Q&A suggestions" in some versions).
4. Enter alternatives as a **comma-separated list**, e.g. `sales, top line, income` for a measure named Revenue.
5. Save and test in the **Q&A visual** with the phrases you added.

Repeat for the 5–10 objects people ask about most. You don’t need to synonym everything — focus on the ones that show up in real questions.

---

## Before / After Example

| Object   | Before (no synonyms)     | After (synonyms)                    |
|----------|--------------------------|-------------------------------------|
| Measure: Revenue | Only "Revenue" works   | "revenue," "sales," "top line," "income" |
| Measure: Gross Margin % | Only exact name   | "margin," "profit %," "GM," "gross margin" |
| Column: Customer Name | Only "Customer Name" | "customer," "client," "account name" |

**Test:** Ask "What was sales by customer last month?" — it should now map to Revenue and Customer Name and return a sensible visual.

---

## Best Practices

- **Match how people talk** — Use terms from emails, meetings, and support tickets.
- **Plurals and abbreviations** — Add "revenue" and "revenues," "GM" and "gross margin."
- **Keep a list** — Use the **templates/qa-synonyms-checklist.md** so you can reuse and share with the team.

---

## In Microsoft Fabric

Semantic models in Fabric use the same idea: **synonyms on tables, columns, and measures**. Curate your model there the same way. When you use Copilot or Data Agents, the same synonyms help — they all rely on the semantic model’s language.

---

## Template

Use **templates/qa-synonyms-checklist.md** to plan your synonyms before or while you add them in the model. Copy the example rows and fill in your own measures and columns.
