# Fabric and OneLake Readiness

**Get your data and semantic model ready for Fabric, Copilot, and Data Agents — without a big migration.**

---

## What You’re Preparing For

When you adopt **Microsoft Fabric**, the same semantic model and Q&A improvements (names, synonyms, hierarchies) carry over. Fabric adds **Copilot**, **Data Agents**, and **OneLake** — so the better your model’s language and structure now, the better those tools work later.

---

## Do This First

1. **Nail Q&A in Power BI** — Use the other two guides. A model that answers plain-English questions in Power BI will do the same in Fabric.
2. **Document your model** — Table and measure names, a short list of key synonyms, and one or two hierarchies. That’s your handoff doc when you move to Fabric.
3. **OneLake when you’re ready** — Organize data (lakehouse/warehouse) so it lines up with how your semantic model expects it: consistent names, clear folders, and a refresh path you can automate.

---

## Semantic Models in Fabric

- **Same synonyms, same Q&A** — What you set in Power BI (or in Fabric’s semantic model) is what Copilot and Data Agents use.
- **Curate once** — Good names and synonyms in the model mean better answers everywhere: report Q&A, Copilot, and agents.

---

## OneLake and Data Curation

- Put data in **OneLake** in a way that matches your reporting: one lakehouse or warehouse per area (e.g. sales, ops) if that’s how you think about it.
- Use **consistent naming** and folder structure so the semantic model’s sources stay clear and maintainable.
- When you add **Data Agents** or **Copilot**, they’ll use the same semantic model — so the curation you do now pays off.

---

## Checklist

- [ ] Q&A works well in Power BI (names, synonyms, hierarchies from the other guides)
- [ ] Key tables and measures are documented (for handoff or Fabric migration)
- [ ] When you create or move to Fabric, OneLake structure supports your semantic model and refresh
- [ ] Access and refresh are configured so the right people and jobs can use the data

---

## Next Steps

Use the **Q&A Readiness** and **Linguistic Schemas and Synonyms** guides to get the model in shape first. Then plan Fabric/OneLake around that model instead of the other way around.
