# Examples: Python + Power BI / Fabric API

Run these from **Visual Studio Code** (or any terminal) after setting up the guide in `../guides/python-fabric-api-pbip.md`.

## Quick run from VS Code

1. **Open folder**  
   File → Open Folder → select this `examples` folder (or the parent `ai-ready-semantic-model-kit` folder).

2. **Terminal**  
   Open Terminal (Ctrl+`). Create and activate a venv:
   ```bash
   python -m venv .venv
   .\.venv\Scripts\Activate   # Windows PowerShell
   # or: source .venv/bin/activate   # Mac/Linux
   pip install msal requests python-dotenv
   ```

3. **Environment**  
   Copy `.env.example` to `.env` and set `AZURE_CLIENT_ID` and `AZURE_TENANT_ID` (from your Azure AD app).

4. **Interpreter**  
   Ctrl+Shift+P → **Python: Select Interpreter** → choose the `.venv` Python.

5. **Run**  
   Open `list_workspaces.py` → right-click → **Run Python File in Terminal**, or in the terminal:
   ```bash
   python list_workspaces.py
   ```
   A browser will open for sign-in; then the script lists your Power BI/Fabric workspaces.

## Files

| File | Purpose |
|------|---------|
| `list_workspaces.py` | Lists workspaces using MSAL + Power BI REST API. |
| `.env.example` | Template for `.env` (copy to `.env` and fill in). |

See **../guides/python-fabric-api-pbip.md** for the full Python + Fabric API + PBIP path and more detail.
