# AI-Ready Semantic Model Kit

**Stop "Q&A doesn't work" — get your Power BI model answering plain-English questions in an afternoon.**

Your report is solid, but when someone asks "What was sales last month?" in the Q&A box, they get nothing useful or the wrong chart. This kit gives you the exact levers: **better names, synonyms, and a small set of best practices** so the same model starts answering real questions. No rip-and-replace. No Fabric required to start.

---

## What You Get

- **Q&A Readiness** — What actually breaks Q&A (and how to fix it with names and hierarchies)
- **Synonyms that stick** — Where to add them in Power BI (and Fabric), with before/after examples
- **Fabric/OneLake readiness** — What to do first when you’re ready for Copilot or Data Agents
- **Python + Fabric REST API + PBIP** — Use Python to call the Power BI/Fabric API, work with PBIP folders, and run scripts from Visual Studio Code
- **Working checklist** — Tables and examples you can copy into your own model

**Outcome:** Your existing semantic model becomes something people can *ask* instead of only click. When you move to Fabric, you’re already in good shape. If you automate or deploy via API, the Python + PBIP path is covered too.

---

## Who This Is For

- You already have a Power BI semantic model (or are building one) and want Q&A to work.
- You’re planning Fabric or Copilot and want the model ready, not retrofitted later.
- You want to run Python scripts against the Power BI/Fabric REST API or work with PBIP from VS Code.
- You’re tired of generic “enable Q&A” advice and want a clear, step-by-step path.

---

## Quick Start (About 30 Minutes)

1. Open **Q&A Readiness** — run through the checklist on one table or one report.
2. Pick **3–5 measures** people ask about (e.g. revenue, margin, count of orders) and add synonyms using **Linguistic Schemas and Synonyms**.
3. Test in the Q&A visual with the exact phrases your users say.
4. Use the **templates** to document what you did so the next model is faster.

**Python + API + PBIP from VS Code:** Open the **examples** folder in VS Code → create a venv, `pip install msal requests python-dotenv` → copy `.env.example` to `.env` and set `AZURE_CLIENT_ID` and `AZURE_TENANT_ID` → run `list_workspaces.py`. Full steps are in **guides/python-fabric-api-pbip.md**.

---

## What’s Inside

| Guide | What it does |
|-------|----------------|
| **guides/q-and-a-readiness.md** | Why Q&A fails, what to fix first, and a short checklist |
| **guides/linguistic-schemas-and-synonyms.md** | Where to add synonyms in Power BI (and Fabric), with examples |
| **guides/fabric-onelake-readiness.md** | First steps for Fabric/OneLake so data is ready for AI and agents |
| **guides/python-fabric-api-pbip.md** | Python, Power BI/Fabric REST API, PBIP, and **how to run from Visual Studio Code** |
| **templates/qa-synonyms-checklist.md** | Editable checklist with example rows you can copy |
| **examples/** | Sample Python script (`list_workspaces.py`) and `.env.example` — run from VS Code (see examples/README.md) |

---

## Support

Questions or stuck? **info@aureaquantra.com** — we use this stuff on client models every day.

**Need hands-on help?** We do semantic model design, Q&A tuning, and Fabric rollout as consulting. [Request a discovery call](https://aureaquantra.com/contact/#contact-form) to see if we’re a fit.
